#include <stdio.h>
#include <string.h>
#include <windows.h>

// Catch to use CDirectWork
#define GEC_DIRECTWORK	110	

class CCBWaveEditor {
public:
	// General Functions
	virtual HWND    GetMainBuzzWindow();
	virtual HWND    GetWaveTableWindow();

	// Wave Table Entries - General
	virtual int     CreateNewEntry(int samplesize, char * name);
	virtual int     GetNumOfNotes(int index);
	virtual bool    IsThereSample(int index);

	// Wave Table Entries - Retrieving
	virtual char  * GetSampleName(int index);
	virtual short * GetSamples(int index, int note);
	virtual int     GetNumSamples(int index, int note);
	virtual int     GetNumChannels(int index);
	virtual int     GetLoopStart(int index, int note);
	virtual int     GetLoopEnd(int index, int note);
	virtual int     GetSamplerate(int index, int note);
	virtual int     GetRootNote(int index, int note);
	virtual float   GetVolume(int index);
	virtual bool    IsLooped(int index);

	// Wave Table Entries - Setting
	virtual int     SetNumChannels(int index, int value);
	virtual int     SetLoopStart(int index, int note, int value);
	virtual int     SetLoopEnd(int index, int note, int value);
	virtual int     SetSamplerate(int index, int note, int value);
	virtual int     SetRootNote(int index, int note, int value);
	virtual int     SetVolume(int index, float value);
	virtual int     SetLooped(int index, bool value);

	virtual int     SetTo16BitPCM   (int index);
	virtual int     SetTo32BitFloat (int index);
	virtual int CreateSpecificEntry(int index, int samplesize, char * name);
	virtual HWND	GetFileBrowserWnd();

	virtual void     WavePlayerReserve();
	virtual float *  WavePlayerCreateBuffer(int samplesize, int samplerate);
	virtual void     WavePlayerPlay();

	virtual void SetSampleName(int position, char * newname);

	virtual int     SetTo32BitPCM (int index);
	virtual int     SetTo24BitPInt (int index);
	virtual int     GetSampleType (int index);
	virtual int     SetSampleType (int index, int type);

};

class CWaveBrowserHandler {
public:
	virtual void __cdecl AddItem(char * name, char *type, char *size, char *path, int icon);
	virtual bool __cdecl IsNormalFileSystem(char * name);
	virtual void __cdecl CantLoadReason(char *reason, char *originator);
	virtual int __cdecl  GetWaveEditorPosition();
	virtual CCBWaveEditor * __cdecl GetWaveEditorClass();
	virtual float * __cdecl GetWavePlayerBuffer(int samplesize, int samplerate);
	virtual void __cdecl WavePlayerReserve();
	virtual void __cdecl WavePlayerPlay();
};

class CWTHelper {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl CanPreview(char * name);
	virtual bool __cdecl CanImport(char * name);

	virtual bool __cdecl TranslatePathForFile(char * name, char *newname);
	virtual bool __cdecl DoubleClickUseFile(char * name, CWaveBrowserHandler *wbh);
	virtual void __cdecl DoubleClickDisplayFolders(char * name, CWaveBrowserHandler *wbh);
	virtual void __cdecl DoubleClickDisplayFiles(char * name, CWaveBrowserHandler *wbh);

    virtual bool __cdecl Import(char * namex, CWaveBrowserHandler *wbh);
    virtual bool __cdecl Export(float *psamples, int numsamples, char *filename);

	virtual void __cdecl SettingsChanged();
	virtual char * __cdecl HelperWebsiteURL();

	virtual void __cdecl GetExtensionsClass(int param, void **exmodule);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);
};

class CWaveEditorDirectWork {
public:
	virtual char * AboutImplementation();
	virtual void WorkStereo(float *samples, int numsamples, int samplerate);
	virtual void Stop(); // this gets called when the stop button is clicked,
};

#define EXPORTTHING extern "C" { \
	__declspec(dllexport) CWTHelper *  __cdecl CreateHelper() { return new helper; } \
}
